#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include "read_cm_cp_ref.h"

#ifndef EOK
#define EOK 0
#endif

int
get_min_max(char* line, uint32_t *min, uint32_t *max, int num)
{
    const char* tok;
    int i;

    for (tok = strtok(line, "\", "), i = 0; (tok != NULL) && (i < num); tok = strtok(NULL, "\", "), i++)
    {
        min[i] = atoi(tok);

        tok = strtok(NULL, "\", ");
        if (tok != NULL) {
            max[i] = atoi(tok);
        } else {
            i = -1;
            break;
        }
    }

    if (i != num) {
        return -1;
    }

    return EOK;
}

int
read_cm_ref(uint32_t **matrix_min, uint32_t **matrix_max, int x, int y)
{
    int i;
    FILE* fp = fopen(CM_REF_FILE, "r");
    char line[1024];
    char* tmp;

    if (fp == NULL) {
        return -1;
    }

    for (i = 0; i < x; i++) {
        if (fgets(line, 1024, fp) == NULL) {
            break;
        }

        tmp = strdup(line);

        if (get_min_max(tmp, matrix_min[i], matrix_max[i], y) == -1) {
            i = -1;
            free(tmp);
            break;
        }
        free(tmp);
    }

    fclose(fp);

    if (i != x) {
        return -1;
    }

    return EOK;
}

int
read_cp_rx_ref(uint32_t *cp_rx_min, uint32_t *cp_rx_max, int x)
{
    int i;
    FILE* fp = fopen(CP_RX_REF_FILE, "r");
    char line[1024];
    char* tmp;

    if (fp == NULL) {
        return -1;
    }

    for (i = 0; i < x; i++) {
        if (fgets(line, 1024, fp) == NULL) {
            break;
        }

        tmp = strdup(line);

        if (get_min_max(tmp, &cp_rx_min[i], &cp_rx_max[i], 1) == -1) {
            i = -1;
            free(tmp);
            break;
        }
        free(tmp);
    }

    fclose(fp);

    if (i != x) {
        return -1;
    }

    return EOK;
}

int
read_cp_tx_ref(uint32_t *cp_tx_min, uint32_t *cp_tx_max, int y)
{
    FILE* fp = fopen(CP_TX_REF_FILE, "r");
    char line[1024];
    char* tmp;

    if (fp == NULL) {
        return -1;
    }

    if (fgets(line, 1024, fp) == NULL) {
		fclose(fp);
        return -1;
    }

    tmp = strdup(line);

    if (get_min_max(tmp, cp_tx_min, cp_tx_max, y) == -1) {
        free(tmp);
		fclose(fp);
        return -1;
    }
    free(tmp);

    fclose(fp);

    return EOK;
}

#if defined(__QNXNTO__) && defined(__USESRCVERSION)
#include <sys/srcversion.h>
__SRCVERSION("$URL: http://svn.ott.qnx.com/product/branches/7.0.0/trunk/hardware/mtouch/cypress/read_cm_cp_ref.c $ $Rev: 879033 $")
#endif
